@echo off
REM ============================================
REM  ELYMIR - Script d'installation automatique
REM  Fichier : install_elymir.bat
REM ============================================

chcp 65001 >nul 2>&1
title Elymir - Installation
mode con cols=70 lines=35
color 0F

:header
cls
echo.
echo  ╔════════════════════════════════════════════════════════════════╗
echo  ║                                                                ║
echo  ║     ███████╗██╗  ██╗   ██╗███╗   ███╗██╗██████╗               ║
echo  ║     ██╔════╝██║  ╚██╗ ██╔╝████╗ ████║██║██╔══██╗              ║
echo  ║     █████╗  ██║   ╚████╔╝ ██╔████╔██║██║██████╔╝              ║
echo  ║     ██╔══╝  ██║    ╚██╔╝  ██║╚██╔╝██║██║██╔══██╗              ║
echo  ║     ███████╗███████╗██║   ██║ ╚═╝ ██║██║██║  ██║              ║
echo  ║     ╚══════╝╚══════╝╚═╝   ╚═╝     ╚═╝╚═╝╚═╝  ╚═╝              ║
echo  ║                                                                ║
echo  ║              Installation des outils v1.0                      ║
echo  ║                                                                ║
echo  ╚════════════════════════════════════════════════════════════════╝
echo.

REM Vérifier les droits administrateur
net session >nul 2>&1
if %errorLevel% neq 0 (
    color 0C
    echo  ╔════════════════════════════════════════════════════════════════╗
    echo  ║                      ⚠ ATTENTION ⚠                            ║
    echo  ╠════════════════════════════════════════════════════════════════╣
    echo  ║                                                                ║
    echo  ║   Ce script doit etre lance en tant qu'Administrateur !       ║
    echo  ║                                                                ║
    echo  ║   → Clic droit sur le fichier                                 ║
    echo  ║   → "Executer en tant qu'administrateur"                      ║
    echo  ║                                                                ║
    echo  ╚════════════════════════════════════════════════════════════════╝
    echo.
    pause
    exit /b 1
)

echo  ╔════════════════════════════════════════════════════════════════╗
echo  ║                    ✓ Droits administrateur OK                  ║
echo  ╚════════════════════════════════════════════════════════════════╝
echo.

set "SCRIPT_DIR=%~dp0"

echo  ┌────────────────────────────────────────────────────────────────┐
echo  │  Ce script va installer :                                      │
echo  │                                                                │
echo  │    • XAMPP (Apache + PHP + MySQL)    →  C:\xampp               │
echo  │    • FFmpeg (conversion video)       →  C:\ffmpeg              │
echo  │    • ionCube Loader (decodeur PHP)   →  C:\xampp\php\ext       │
echo  │                                                                │
echo  └────────────────────────────────────────────────────────────────┘
echo.
echo  Appuyez sur une touche pour commencer l'installation...
pause >nul

REM ============================================
REM  ETAPE 1 : Installation de XAMPP
REM ============================================
cls
call :header_mini
echo.
echo  ╔════════════════════════════════════════════════════════════════╗
echo  ║  ETAPE 1/5                              ░░░░░░░░░░░░░░░░  20%%  ║
echo  ║  Installation de XAMPP                                         ║
echo  ╚════════════════════════════════════════════════════════════════╝
echo.

if exist "C:\xampp" (
    color 0E
    echo  ┌────────────────────────────────────────────────────────────────┐
    echo  │  ⚠ Le dossier C:\xampp existe deja                            │
    echo  └────────────────────────────────────────────────────────────────┘
    echo.
    choice /C ON /M "  Voulez-vous le remplacer ? (O=Oui, N=Non)"
    if errorlevel 2 goto skip_xampp
    echo.
    echo  Suppression de l'ancien XAMPP...
    rmdir /S /Q "C:\xampp"
    color 0F
)

echo  Copie de XAMPP vers C:\xampp...
echo  Veuillez patienter, cela peut prendre quelques minutes...
echo.
xcopy "%SCRIPT_DIR%xampp" "C:\xampp" /E /I /H /Y /Q
if %errorLevel% neq 0 (
    color 0C
    echo  [ERREUR] Echec de la copie de XAMPP
    pause
    exit /b 1
)
echo.
echo  ✓ XAMPP installe avec succes
timeout /t 2 >nul
:skip_xampp

REM ============================================
REM  ETAPE 2 : Installation de FFmpeg
REM ============================================
cls
call :header_mini
echo.
echo  ╔════════════════════════════════════════════════════════════════╗
echo  ║  ETAPE 2/5                              ████░░░░░░░░░░░░  40%%  ║
echo  ║  Installation de FFmpeg                                        ║
echo  ╚════════════════════════════════════════════════════════════════╝
echo.

if exist "C:\ffmpeg" (
    color 0E
    echo  ┌────────────────────────────────────────────────────────────────┐
    echo  │  ⚠ Le dossier C:\ffmpeg existe deja                           │
    echo  └────────────────────────────────────────────────────────────────┘
    echo.
    choice /C ON /M "  Voulez-vous le remplacer ? (O=Oui, N=Non)"
    if errorlevel 2 goto skip_ffmpeg
    echo.
    echo  Suppression de l'ancien FFmpeg...
    rmdir /S /Q "C:\ffmpeg"
    color 0F
)

echo  Copie de FFmpeg vers C:\ffmpeg...
echo.
xcopy "%SCRIPT_DIR%ffmpeg" "C:\ffmpeg" /E /I /H /Y /Q
if %errorLevel% neq 0 (
    color 0C
    echo  [ERREUR] Echec de la copie de FFmpeg
    pause
    exit /b 1
)
echo.
echo  ✓ FFmpeg installe avec succes
timeout /t 2 >nul
:skip_ffmpeg

REM ============================================
REM  ETAPE 3 : Installation de ionCube Loader
REM ============================================
cls
call :header_mini
echo.
echo  ╔════════════════════════════════════════════════════════════════╗
echo  ║  ETAPE 3/5                              ██████░░░░░░░░░░  60%%  ║
echo  ║  Installation de ionCube Loader                                ║
echo  ╚════════════════════════════════════════════════════════════════════╝
echo.

if not exist "C:\xampp\php\ext" (
    color 0C
    echo  [ERREUR] Le dossier C:\xampp\php\ext n'existe pas
    echo  Verifiez que XAMPP est bien installe
    pause
    exit /b 1
)

echo  Copie de ionCube Loader...
echo.
copy /Y "%SCRIPT_DIR%ioncube\ioncube_loader_win_8.2.dll" "C:\xampp\php\ext\" >nul
if %errorLevel% neq 0 (
    color 0C
    echo  [ERREUR] Echec de la copie de ionCube
    pause
    exit /b 1
)
echo  ✓ ionCube Loader installe avec succes
timeout /t 2 >nul

REM ============================================
REM  ETAPE 4 : Configuration de php.ini
REM ============================================
cls
call :header_mini
echo.
echo  ╔════════════════════════════════════════════════════════════════╗
echo  ║  ETAPE 4/5                              ████████░░░░░░░░  80%%  ║
echo  ║  Configuration de PHP                                          ║
echo  ╚════════════════════════════════════════════════════════════════╝
echo.

set "PHP_INI=C:\xampp\php\php.ini"
set "TEMP_INI=C:\xampp\php\php.ini.tmp"

REM Vérifier si ionCube est déjà configuré
findstr /C:"ioncube_loader" "%PHP_INI%" >nul 2>&1
if %errorLevel% equ 0 (
    echo  ℹ ionCube deja configure dans php.ini
    goto skip_phpini
)

echo  Configuration de php.ini...
echo.

REM Ajouter la ligne ionCube en haut du fichier
echo zend_extension = "C:\xampp\php\ext\ioncube_loader_win_8.2.dll"> "%TEMP_INI%"
type "%PHP_INI%" >> "%TEMP_INI%"
move /Y "%TEMP_INI%" "%PHP_INI%" >nul

echo  ✓ php.ini configure avec succes
:skip_phpini
timeout /t 2 >nul

REM ============================================
REM  ETAPE 5 : Configuration du PATH
REM ============================================
cls
call :header_mini
echo.
echo  ╔════════════════════════════════════════════════════════════════╗
echo  ║  ETAPE 5/5                              ██████████████░░  95%%  ║
echo  ║  Configuration du systeme                                      ║
echo  ╚════════════════════════════════════════════════════════════════╝
echo.

REM Vérifier si FFmpeg est déjà dans le PATH
echo %PATH% | findstr /C:"C:\ffmpeg\bin" >nul 2>&1
if %errorLevel% equ 0 (
    echo  ℹ FFmpeg deja present dans le PATH
    goto skip_path
)

echo  Ajout de FFmpeg au PATH systeme...
echo.
setx PATH "%PATH%;C:\ffmpeg\bin" >nul 2>&1
echo  ✓ PATH configure avec succes
:skip_path
timeout /t 2 >nul

REM ============================================
REM  TERMINÉ
REM ============================================
cls
color 0A
echo.
echo  ╔════════════════════════════════════════════════════════════════╗
echo  ║                                                                ║
echo  ║     ███████╗██╗  ██╗   ██╗███╗   ███╗██╗██████╗               ║
echo  ║     ██╔════╝██║  ╚██╗ ██╔╝████╗ ████║██║██╔══██╗              ║
echo  ║     █████╗  ██║   ╚████╔╝ ██╔████╔██║██║██████╔╝              ║
echo  ║     ██╔══╝  ██║    ╚██╔╝  ██║╚██╔╝██║██║██╔══██╗              ║
echo  ║     ███████╗███████╗██║   ██║ ╚═╝ ██║██║██║  ██║              ║
echo  ║     ╚══════╝╚══════╝╚═╝   ╚═╝     ╚═╝╚═╝╚═╝  ╚═╝              ║
echo  ║                                                                ║
echo  ╠════════════════════════════════════════════════════════════════╣
echo  ║                                                                ║
echo  ║          ✓ INSTALLATION TERMINEE AVEC SUCCES !                ║
echo  ║                                                                ║
echo  ╠════════════════════════════════════════════════════════════════╣
echo  ║                                                                ║
echo  ║   Prochaines etapes :                                         ║
echo  ║                                                                ║
echo  ║   1. Lancez XAMPP    →  C:\xampp\xampp-control.exe            ║
echo  ║   2. Demarrez Apache et MySQL (boutons "Start")               ║
echo  ║   3. Copiez Elymir   →  C:\xampp\htdocs\Elymir                ║
echo  ║   4. Ouvrez          →  http://localhost/Elymir               ║
echo  ║                                                                ║
echo  ╚════════════════════════════════════════════════════════════════╝
echo.
choice /C ON /M "  Lancer XAMPP maintenant ? (O=Oui, N=Non)"
if errorlevel 2 goto end
start "" "C:\xampp\xampp-control.exe"

:end
color 0F
echo.
echo  ┌────────────────────────────────────────────────────────────────┐
echo  │            Merci d'avoir choisi Elymir !                       │
echo  │                   https://elymir.fr                            │
echo  └────────────────────────────────────────────────────────────────┘
echo.
pause
exit /b 0

:header_mini
echo.
echo  ╔════════════════════════════════════════════════════════════════╗
echo  ║                ELYMIR - Installation                           ║
echo  ╚════════════════════════════════════════════════════════════════╝
goto :eof